/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: $
   Last Modification:
    $Author: Robert $
    $Modtime: $
    $Revision: 6462 $

   Targets:
     MCF51CN128   : yes

   Description:
   cifX parallel DPM Interface

   Changes:

     Version   Date        Author   Description
      ----------------------------------------------------------------------------------
      2        23.07.2014  RM       changed function parameters of MCF51CN128_ParDPM_Read
                                    and MCF51CN128_ParDPM_Write according to new toolkit types
      1        01.03.2011  SS       initial version

**************************************************************************************/

/*****************************************************************************/
/*! \file MCF51CN128ParDPMInterface.h
*   cifX parallel DPM interface function definition                                   */
/*****************************************************************************/

#ifndef MCF51CN128_PARDPMINTERFACE__H
#define MCF51CN128_PARDPMINTERFACE__H

#ifdef __cplusplus
extern "C"
{
#endif

#include "OS_Dependent.h"

int32_t MCF51CN128_ParDPM_Init( void);
void*   MCF51CN128_ParDPM_Read( void* pvDevInstance, void* pvAddr, void* pvData, uint32_t ulLen);
void*   MCF51CN128_ParDPM_Write( void* pvDevInstance, void* pvAddr, void* pvData, uint32_t ulLen);

#ifdef __cplusplus
}
#endif

#endif /* MCF51CN128_PARDPMINTERFACE__H */
